import oscP5.*;
import netP5.*;

OscP5 oscP5;
NetAddress myRemoteLocation;

int portIncoming = 8000; // port for incoming OSC message
int portOutgoing = 9000; // port for outgoing OSC message 
String remoteIP = "10.0.1.4"; // IP address of the TouchOSC device
boolean debugMode = true; // print or not the values
String debugMessage = "";
String labelMessage = "";

// NB: all table start at 1 
PVector[] xyPad = new PVector[5]; // the 4 pads on the top
float[][] multiFade = new float[3][13];  // the 2 multifades (initial value = 0.5)
float[] rotary = new float[8]; // the 7 rotaries
float[] fader = new float[9]; // the 8 faders
int[] push = new int[9]; // the 8 push buttons
int[][] multitoggle = new int [6][6]; // the 5x5 multitoggle
PVector accelerometer = new PVector(); // accelerometer (better disable on touchOSC if not used cause it's sending oscMessage non stop)

void setup() {
  initOSC();
}

void draw() {
}

void oscEvent(OscMessage theOscMessage) {
  String addr = theOscMessage.addrPattern();     
  debugMessage = addr + " |  ";   // uncomment for seeing the raw message

  // Top XYPads 
  if(addr.indexOf("/1/xy") !=-1){ 
    String list[] = split(addr,'/');
    int i = int(list[2].charAt(2) - 0x30);
    xyPad[i].x = theOscMessage.get(0).floatValue();
    xyPad[i].y = theOscMessage.get(1).floatValue();
    debugMessage += "Pad" + i + " x=" + xyPad[i].x  + " y=" + xyPad[i].y;  
  }
  
  // Multifades
  if(addr.indexOf("/1/multifader") !=-1){
    String list[] = split(addr,'/');
    int i = int(list[2].charAt(10) - 0x30);    
    int x = int(list[3]);
    multiFade[i][x]  = theOscMessage.get(0).floatValue();
    debugMessage += "Multifade" + i + " " + x + "= " + multiFade[i][x];  
  }
  
  // Faders
  if(addr.indexOf("/1/fader") !=-1){ 
    String list[] = split(addr,'/');
    int  xfader = int(list[2].charAt(5) - 0x30);
    fader[xfader]  = theOscMessage.get(0).floatValue();
    debugMessage += "Fader" + xfader + " ="+fader[xfader]; 
  }

  // Rotaries
  if(addr.indexOf("/1/rotary") !=-1){ 
    String list[] = split(addr,'/');
    int  xrotary = int(list[2].charAt(6) - 0x30);
    rotary[xrotary]  = theOscMessage.get(0).floatValue();
    debugMessage += "Rotary" + xrotary + " =" + rotary[xrotary]; 
  }

  // Push Buttons
  if(addr.indexOf("/1/push") !=-1){   // the strip at the bottom
    int i = int((addr.charAt(7) )) - 0x30;   // retrns the ASCII number so convert into a real number by subtracting 0x30
    push[i]  = int(theOscMessage.get(0).floatValue());
    debugMessage += "Push" + i + "= " + push[i];   
  }

  // Multitoggle 5 x 5  
  if(addr.indexOf("/1/multitoggle/") !=-1){ 
    String list[] = split(addr,'/');
    int x = int(list[3]);
    int y = int(list[4]);
    multitoggle[x][y]  = int(theOscMessage.get(0).floatValue());
    debugMessage += "multitoggle x=" + x + " y=" + y + " Value=" + multitoggle[x][y]; 
  }
 
  // Accelerometer 
  if(addr.indexOf("accxyz") !=-1){
    // since the layout of the OSC is inverted we invert all the values
    accelerometer.x = - theOscMessage.get(0).floatValue(); // default 0 from -1 to 1
    accelerometer.y = - theOscMessage.get(1).floatValue(); // default 0 from -1 to 1
    accelerometer.z = - theOscMessage.get(2).floatValue(); // default 1 from 0 to 2 (
    debugMessage += "x= " + accelerometer.x + " y=" + accelerometer.y + " z=" + accelerometer.z;
  }

  if (debugMode) println(debugMessage);
  updateOSC();

}

void initOSC() {
  /* start oscP5, listening for incoming messages at port 8000 */
  oscP5 = new OscP5(this, portIncoming);
  /* myRemoteLocation is a NetAddress. a NetAddress takes 2 parameters,
   * an ip address and a port number. myRemoteLocation is used as parameter in
   * oscP5.send() when sending osc packets to another computer, device, 
   * application. usage see below. for testing purposes the listening port
   * and the port of the remote location address are the same, hence you will
   * send messages back to this sketch.
   */
  myRemoteLocation = new NetAddress(remoteIP, portOutgoing);
  // VAR
  // create PVectors  
  for (int i=0; i<5; i++) xyPad[i] = new PVector();
}


void updateOSC() {
  // map your var here
  
  labelMessage = "";
  // send message to the iPad to update labels
  OscMessage myMessage = new OscMessage("/1/label1");
  myMessage.add(labelMessage);
  oscP5.send(myMessage, myRemoteLocation); 
}
